/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import dev.tr7zw.transition.mc.entitywrapper.PlayerWrapper;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.versionless.ModBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_918;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.PlayerHandler;

public class MinecraftCapesSupport
implements ModSupport {
    private MinecraftCapesRenderer render = new MinecraftCapesRenderer();
    private Function<PlayerWrapper, PlayerHandler> getCape = null;

    private void init(PlayerWrapper test) {
        try {
            this.getCape = player -> {
                class_1657 entity = player.getEntity();
                PlayerHandler.get((UUID)entity.method_5667()).getCapeLocation();
                return PlayerHandler.get((UUID)entity.method_5667());
            };
            this.getCape.apply(test);
            ModBase.LOGGER.info("Using 'get(UUID)' method for MinecraftCapes.");
            return;
        }
        catch (Throwable throwable) {
            for (Method m : PlayerHandler.class.getMethods()) {
                try {
                    if (m.getReturnType() != PlayerHandler.class && m.getParameterCount() == 1 && m.getParameterTypes()[0] != UUID.class) continue;
                    m.invoke(null, test);
                    this.getCape = player -> {
                        try {
                            return (PlayerHandler)m.invoke(null, player);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            return null;
                        }
                    };
                    ModBase.LOGGER.info("Using '" + m.getName() + "' method for MinecraftCapes.");
                    return;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            this.getCape = player -> null;
            ModBase.LOGGER.info("Unable to find a method for MinecraftCapes.");
            return;
        }
    }

    @Override
    public boolean shouldBeUsed(PlayerWrapper capeRenderInfo) {
        PlayerHandler handler;
        if (!MinecraftCapesConfig.isCapeVisible()) {
            return false;
        }
        if (this.getCape == null) {
            this.init(capeRenderInfo);
        }
        return (handler = this.getCape.apply(capeRenderInfo)) != null && handler.getCapeLocation() != null;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    private class MinecraftCapesRenderer
    implements CapeRenderer {
        private MinecraftCapesRenderer() {
        }

        @Override
        public class_4588 getVertexConsumer(class_4597 multiBufferSource, PlayerWrapper capeRenderInfo) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(capeRenderInfo);
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                return class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_23580((class_2960)playerHandler.getCapeLocation()), (boolean)playerHandler.getHasCapeGlint());
            }
            return class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_23580((class_2960)capeRenderInfo.getCapeTexture()), (boolean)false);
        }
    }
}

